@extends('layouts.admin')

@section('content')
    <!-- Page Header -->
    <div class="py-6 bg-[#F6F6F6] border-b border-[#CBB4B0]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900">Detail Perusahaan</h1>
                    <p class="text-gray-600 mt-1">{{ $company->name }}</p>
                </div>
                <div class="flex items-center space-x-4">
                    <a href="{{ route('admin.companies.index') }}" 
                       class="bg-[#8B8B8B] text-white px-4 py-2 rounded-none hover:bg-[#192D50] transition duration-150">
                        Kembali
                    </a>
                    <a href="{{ route('admin.companies.edit', $company) }}" 
                       class="bg-[#192D50] text-white px-4 py-2 rounded-none hover:bg-[#8B8B8B] transition duration-150">
                        Edit
                    </a>
                    <a href="{{ route('admin.employees.by-company', $company) }}" 
                       class="bg-[#192D50] text-white px-4 py-2 rounded-none hover:bg-[#8B8B8B] transition duration-150">
                        Lihat Karyawan
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="py-8 bg-[#F6F6F6]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Stats Cards -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-[#192D50] rounded-full flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Status</p>
                                <p class="text-2xl font-semibold text-gray-900">
                                    <span class="{{ $company->is_active ? 'text-green-600' : 'text-red-600' }}">
                                        {{ $company->is_active ? 'Aktif' : 'Tidak Aktif' }}
                                    </span>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-[#8B8B8B] rounded-full flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Total Karyawan</p>
                                <p class="text-2xl font-semibold text-gray-900">{{ $company->employees->count() }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-[#192D50] rounded-full flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Kode Perusahaan</p>
                                <p class="text-lg font-semibold text-gray-900 font-mono">{{ $company->company_code }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-[#8B8B8B] rounded-full flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Kode Akses</p>
                                <p class="text-lg font-semibold text-gray-900 font-mono">{{ $company->access_code }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                <!-- Company Information -->
                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Perusahaan</h3>
                        
                        <dl class="space-y-4">
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Nama Perusahaan</dt>
                                <dd class="text-sm text-gray-900">{{ $company->name }}</dd>
                            </div>
                            
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Email</dt>
                                <dd class="text-sm text-gray-900">{{ $company->email }}</dd>
                            </div>
                            
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Telepon</dt>
                                <dd class="text-sm text-gray-900">{{ $company->phone }}</dd>
                            </div>
                            
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Alamat</dt>
                                <dd class="text-sm text-gray-900">{{ $company->address }}</dd>
                            </div>
                            
                            @if($company->description)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Deskripsi</dt>
                                <dd class="text-sm text-gray-900">{{ $company->description }}</dd>
                            </div>
                            @endif
                        </dl>
                    </div>
                </div>

                <!-- Contact Information -->
                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Kontak</h3>
                        
                        <dl class="space-y-4">
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Nama Kontak</dt>
                                <dd class="text-sm text-gray-900">{{ $company->contact_person }}</dd>
                            </div>
                            
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Email Kontak</dt>
                                <dd class="text-sm text-gray-900">{{ $company->contact_email }}</dd>
                            </div>
                            
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Telepon Kontak</dt>
                                <dd class="text-sm text-gray-900">{{ $company->contact_phone }}</dd>
                            </div>
                        </dl>
                    </div>
                </div>
            </div>

            <!-- Access Codes & Password -->
            <div class="mt-8 bg-white overflow-hidden shadow-sm sm:rounded-none">
                <div class="p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-medium text-gray-900">Kode Akses & Password</h3>
                        <form method="POST" action="{{ route('admin.companies.generate-access-code', $company) }}" class="inline">
                            @csrf
                            <button type="submit" 
                                    class="bg-[#192D50] text-white px-4 py-2 rounded-none text-sm font-medium hover:bg-[#8B8B8B] transition duration-150">
                                Generate Kode Baru
                            </button>
                        </form>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div class="bg-[#F6F6F6] p-4 rounded-none border border-[#CBB4B0]">
                            <h4 class="font-medium text-gray-900 mb-2">Kode Perusahaan</h4>
                            <p class="text-2xl font-mono font-bold text-gray-900">{{ $company->company_code }}</p>
                            <p class="text-sm text-gray-500 mt-1">Digunakan untuk identifikasi perusahaan</p>
                        </div>
                        
                        <div class="bg-[#F6F6F6] p-4 rounded-none border border-[#CBB4B0]">
                            <h4 class="font-medium text-gray-900 mb-2">Kode Akses</h4>
                            <p class="text-2xl font-mono font-bold text-gray-900">{{ $company->access_code }}</p>
                            <p class="text-sm text-gray-500 mt-1">Digunakan untuk login ke sistem MCU</p>
                        </div>
                        
                        <div class="bg-[#F6F6F6] p-4 rounded-none border border-[#CBB4B0]">
                            <h4 class="font-medium text-gray-900 mb-2">Password</h4>
                            <div class="flex items-center space-x-2">
                                <p class="text-2xl font-mono font-bold text-gray-900" id="password-display">••••••••</p>
                                <button type="button" 
                                        onclick="togglePassword()" 
                                        class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                                    <span id="toggle-text">Tampilkan</span>
                                </button>
                            </div>
                            <p class="text-sm text-gray-500 mt-1">Password untuk login ke sistem MCU</p>
                            <!-- Debug info -->
                            <p class="text-xs text-gray-400 mt-1">Debug: Password plain = {{ $company->password_plain ?? 'NULL' }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Employees List -->
            <div class="mt-8 bg-white overflow-hidden shadow-sm sm:rounded-none">
                <div class="p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-medium text-gray-900">Karyawan ({{ $company->employees->count() }})</h3>
                        <a href="{{ route('admin.employees.by-company', $company) }}" 
                           class="bg-[#192D50] text-white px-4 py-2 rounded-none text-sm font-medium hover:bg-[#8B8B8B] transition duration-150">
                            Lihat Semua
                        </a>
                    </div>
                    
                    @if($company->employees->count() > 0)
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-[#192D50]">
                                    <tr>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Posisi</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-[#F6F6F6] divide-y divide-[#CBB4B0]">
                                    @foreach($company->employees->take(5) as $employee)
                                        <tr>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm font-medium text-gray-900">{{ $employee->name }}</div>
                                                <div class="text-sm text-gray-500">{{ $employee->employee_number }}</div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $employee->position }}</td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                                    @if($employee->is_active) bg-green-100 text-green-800
                                                    @else bg-red-100 text-red-800 @endif">
                                                    {{ $employee->is_active ? 'Aktif' : 'Tidak Aktif' }}
                                                </span>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                                <a href="{{ route('admin.employees.show', $employee) }}" 
                                                   class="text-[#CBB4B0] hover:text-[#8B8B8B]">Detail</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-8">
                            <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-gray-100">
                                <svg class="h-6 w-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                                </svg>
                            </div>
                            <h3 class="mt-4 text-lg font-medium text-gray-900">Belum Ada Karyawan</h3>
                            <p class="mt-2 text-sm text-gray-600">
                                Perusahaan ini belum memiliki karyawan.
                            </p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

<script>
function togglePassword() {
    console.log('Toggle password clicked');
    const passwordDisplay = document.getElementById('password-display');
    const toggleText = document.getElementById('toggle-text');
    const passwordPlain = '{{ $company->password_plain }}';
    
    console.log('Password plain from server:', passwordPlain);
    console.log('Current display text:', passwordDisplay.textContent);
    
    if (passwordDisplay.textContent === '••••••••') {
        passwordDisplay.textContent = passwordPlain;
        toggleText.textContent = 'Sembunyikan';
        console.log('Password shown');
    } else {
        passwordDisplay.textContent = '••••••••';
        toggleText.textContent = 'Tampilkan';
        console.log('Password hidden');
    }
}

// Debug: Log when page loads
document.addEventListener('DOMContentLoaded', function() {
    console.log('Page loaded, password plain available:', '{{ $company->password_plain }}');
});
</script>
